<?php
/**
 * Гостевая гнига на файлах AGB!
 * Автор: Jeey
 * Email: jeey@mail.ru
 * ICQ: 9510787
 * Сайт: http://jeey.ru
 */

// ББ коды и смайлы

function bbcodesmile($str)
{
	$bbcode = array(
	'/\[b\](.+)\[\/b\]/isU' => '<strong>$1</strong>',
	'/\[red\](.+)\[\/red\]/isU' => '<span class="red">$1</span>',
	'/\[green\](.+)\[\/green\]/isU' => '<span class="green">$1</span>',
	'/\[blue\](.+)\[\/blue\]/isU' => '<span class="blue">$1</span>');

	function bbcode_url($bbcode)
	{
		return '<a href="' . PATH . '?site=' . urlencode($bbcode[1]) . '">' . $bbcode[2] . '</a>';
	}

    $str = preg_replace_callback('/\[url=(.+)\](.+)\[\/url\]/isU', 'bbcode_url', $str, Q_BBCODE);

    $str = preg_replace(array_keys($bbcode), array_values($bbcode), $str, Q_BBCODE);
    $str = preg_replace('/:(' . implode('|', array_diff(array_map(create_function('$v', 'return substr($v, 0, -4);'), scandir('smile/')), array(''))) . '):/isU', '<img src="smile/$1.gif" alt=":$1:" />', $str, Q_SMILE);

    return $str;
}

// Возвращает ББ коды и смайлы в исходное состояние. Нужно для редактирования текста

function edittext($str)
{
    $replace = array
    (
        '/<strong>(.*)<\/strong>/isU' => '[b]$1[/b]',
        '/<span class="red">(.*)<\/span>/isU' => '[red]$1[/red]',
        '/<span class="green">(.*)<\/span>/isU' => '[green]$1[/green]',
        '/<span class="blue">(.*)<\/span>/isU' => '[blue]$1[/blue]',
        '/<img src=".*" alt="(.*)" \/>/isU' => '$1'
    );

	function bbcode_deurl($bbcode)
	{
		return '[url=' . urldecode($bbcode[1]) . ']' . $bbcode[2] . '[/url]';
	}

    $str = preg_replace_callback('/<a href=".*?site=(.*)">(.*)<\/a>/isU', 'bbcode_deurl', $str, Q_BBCODE);
    $str = preg_replace(array_keys($replace), array_values($replace), $str);
    $str = str_replace('<br/>', "\r\n", $str);

    return $str;
}

// Транслит

function translate($str)
{
    $translate = array
    (
        'YO' => 'Ё',
        'Yo' => 'Ё',
        'yo' => 'ё',
        'ZH' => 'Ж',
        'Zh' => 'Ж',
        'zh' => 'ж',
        'CH' => 'Ч',
        'Ch' => 'Ч',
        'ch' => 'ч',
        'SH' => 'Ш',
        'Sh' => 'Ш',
        'sh' => 'ш',
        'SHC' => 'Щ',
        'Shc' => 'Щ',
        'shc' => 'щ',
        'QQ' => 'Ъ',
        'qq' => 'ъ',
        '&#039;&#039;' => 'ъ',
        'YE' => 'Э',
        'Ye' => 'Э',
        'ye' => 'э',
        'YU' => 'Ю',
        'Yu' => 'Ю',
        'yu' => 'ю',
        'YA' => 'Я',
        'Ya' => 'Я',
        'ya' => 'я',
        'YI' => 'Ы',
        'Yi' => 'Ы',
        'yi' => 'ы',
        'A' => 'А',
        'a' => 'а',
        'B' => 'Б',
        'b' => 'б',
        'C' => 'Ц',
        'c' => 'ц',
        'D' => 'Д',
        'd' => 'д',
        'E' => 'Е',
        'e' => 'е',
        'F' => 'Ф',
        'f' => 'ф',
        'G' => 'Г',
        'g' => 'г',
        'H' => 'Х',
        'h' => 'х',
        'X' => 'Х',
        'x' => 'х',
        'I' => 'И',
        'i' => 'и',
        'K' => 'К',
        'k' => 'к',
        'L' => 'Л',
        'l' => 'л',
        'M' => 'М',
        'm' => 'м',
        'N' => 'Н',
        'n' => 'н',
        'O' => 'О',
        'o' => 'о',
        'P' => 'П',
        'p' => 'п',
        'Q' => 'Ь',
        'q' => 'ь',
        '&#039;' => 'ь',
        'R' => 'Р',
        'r' => 'р',
        'S' => 'С',
        's' => 'с',
        'T' => 'Т',
        't' => 'т',
        'U' => 'У',
        'u' => 'у',
        'V' => 'В',
        'v' => 'в',
        'W' => 'Ш',
        'w' => 'ш',
        'J' => 'Й',
        'j' => 'й',
        'Z' => 'З',
        'z' => 'з'
    );

    // Вся эта конструкция недопускает транслитирование текста в скобках <> и []
    // Но, скобки <> остаются на месте, а [] в итоге исчезают

    preg_match_all('/<[^<]+>/U', $str, $a);
    preg_match_all('/\[([^\[]+)\]/U', $str, $b);

    $str = strtr($str, $translate);

    preg_match_all('/<[^<]+>/U', $str, $c);
    preg_match_all('/\[([^\[]+)\]/U', $str, $d);

    $str = str_replace(array_values($c[0]), array_values($a[0]), $str);
    $str = str_replace(array_values($d[0]), array_values($b[1]), $str);

    return $str;
}
?>